package ws

import (
	"chatdocdemo/internal/config_parser"
	"chatdocdemo/internal/dto"
	"chatdocdemo/internal/util"
	"encoding/json"
	"fmt"
	"github.com/gogf/gf/v2/net/gclient"
	"github.com/gogf/gf/v2/net/ghttp"
	"github.com/gogf/gf/v2/os/gctx"
	"github.com/gogf/gf/v2/os/glog"
	"github.com/gorilla/websocket"
)

func ChatWithDoc(r *ghttp.Request) {
	url := config_parser.ChatDocApiConf.WsHost() + config_parser.ChatDocApiConf.Urls.Chat + "?" + util.SignAndGetQueryString()
	fmt.Printf("url: %s\n", url)
	chatDocWsClient := gclient.NewWebSocket()
	conn, _, _ := chatDocWsClient.Dial(url, nil)
	defer conn.Close()
	param := &dto.ChatParamForChatDoc{}

	ctx := gctx.GetInitCtx()
	ws, err := r.WebSocket()
	if err != nil {
		glog.Error(ctx, err)
		r.Exit()
	}
	ws.SetCloseHandler(func(code int, text string) error {
		glog.Info(ctx, "ws close code:", code, "text:", text)
		return nil
	})
	conn.SetCloseHandler(func(code int, text string) error {
		glog.Info(ctx, "chatdoc ws close code:", code, "text:", text)
		return nil
	})
	for {
		_, msgBytes, err := ws.ReadMessage()
		if err != nil {
			return
		}
		dealParamForChatDoc(param, msgBytes)
		byteParam, _ := json.Marshal(param)
		glog.Info(ctx, "chatdoc ws sending param:", param)
		conn.WriteMessage(websocket.TextMessage, byteParam)
		chatRes, _ := json.Marshal(dealDataFromChatDoc(conn, param))
		if err = ws.WriteMessage(websocket.TextMessage, chatRes); err != nil {
			return
		}
	}
	glog.Info(ctx, "结束问答")
}

func dealParamForChatDoc(param *dto.ChatParamForChatDoc, paramFromRead []byte) {
	innerParam := new(dto.ChatParam)
	json.Unmarshal(paramFromRead, innerParam)
	param.FileIds = innerParam.FileIds
	if innerParam.Content != "" {
		param.Messages = append(param.Messages, dto.ChatMessage{
			Role:    "user",
			Content: innerParam.Content,
		})
	}
	glog.Info(gctx.GetInitCtx(), "chat param:", param)
}

func dealDataFromChatDoc(conn *websocket.Conn, param *dto.ChatParamForChatDoc) *dto.ChatRes {
	var finalResByte []byte
	chatRes := new(dto.ChatRes)
	chatDocRes := new(dto.ChatDocRes)
LOOP:
	for {
		_, chatDocReturn, err := conn.ReadMessage()
		if err != nil {
			break
		}
		json.Unmarshal(chatDocReturn, chatDocRes)
		if chatDocRes.Code != 0 {
			glog.Error(gctx.GetInitCtx(), "chat doc return error:", chatDocRes)
			break
		}
		switch chatDocRes.Status {
		case 99:
			chatRes.FileRefer = chatDocRes.FileRefer
		case 1:
			finalResByte = append(finalResByte, []byte(chatDocRes.Content)...)
		case 2:
			finalResByte = append(finalResByte, []byte(chatDocRes.Content)...)
			break LOOP
		}
	}
	chatRes.Content = string(finalResByte)
	if chatRes.Content != "" {
		param.Messages = append(param.Messages, dto.ChatMessage{
			Role:    "assistant",
			Content: chatRes.Content,
		})
	}
	return chatRes
}
