package util

import (
	"chatdocdemo/internal/config_parser"
	"crypto/hmac"
	"crypto/sha1"
	"encoding/base64"
	"fmt"
	"github.com/gogf/gf/v2/crypto/gmd5"
	"github.com/gogf/gf/v2/frame/g"
	"github.com/gogf/gf/v2/net/gclient"
	"github.com/gogf/gf/v2/os/gctx"
	"github.com/gogf/gf/v2/util/gconv"
	"time"
)

func SignByAppId(appId string, appSecret string, ts string) string {
	auth := gmd5.MustEncrypt(appId + ts)
	fmt.Println(auth)
	return HmacSha1(appSecret, auth)
}

func HmacSha1(keyStr, value string) string {
	key := []byte(keyStr)
	mac := hmac.New(sha1.New, key)
	mac.Write([]byte(value))
	//进行base64编码
	res := base64.StdEncoding.EncodeToString(mac.Sum(nil))
	return res
}

func SignAndSetHeader(client *gclient.Client) {
	timestamp := gconv.String(time.Now().Unix())
	sign := SignByAppId(config_parser.ChatDocApiConf.AppId, config_parser.ChatDocApiConf.Secret, timestamp)
	client.SetHeader("appId", config_parser.ChatDocApiConf.AppId)
	client.SetHeader("timeStamp", timestamp)
	client.SetHeader("signature", sign)
	g.Log().Infof(gctx.GetInitCtx(), "appId: %v\ntimeStamp: %v\nsignature: %v\n",
		config_parser.ChatDocApiConf.AppId, timestamp, sign)
}

func SignAndGetQueryString() string {
	timestamp := gconv.String(time.Now().Unix())
	sign := SignByAppId(config_parser.ChatDocApiConf.AppId, config_parser.ChatDocApiConf.Secret, timestamp)
	return fmt.Sprintf("appId=%s&timestamp=%s&signature=%s",
		config_parser.ChatDocApiConf.AppId, timestamp, sign)
}
