package chat_doc

import (
	"chatdocdemo/internal/config_parser"
	"chatdocdemo/internal/service"
	"chatdocdemo/internal/util"
	"context"
	"fmt"
	"github.com/gogf/gf/v2/frame/g"
	"github.com/gogf/gf/v2/net/ghttp"
)

func init() {
	service.RegisterChatDocLogic(&sChatDocLogic{})
}

type sChatDocLogic struct {
}

func (c *sChatDocLogic) UploadFile(ctx context.Context, file *ghttp.UploadFile) (string, error) {

	filename, err := file.Save(config_parser.ChatDocApiConf.TmpFileDir, true)
	if err != nil {
		return "", err
	}

	absPath := config_parser.ChatDocApiConf.TmpFileDir + "/" + filename
	httpClient := g.Client()
	util.SignAndSetHeader(httpClient)
	result, err := httpClient.Post(ctx,
		config_parser.ChatDocApiConf.HttpHost()+config_parser.ChatDocApiConf.Urls.UploadFile,
		fmt.Sprintf(`file=@file:%s&fileType=%s`, absPath, "wiki"))
	defer result.Close()
	return result.ReadAllString(), nil
}
