package dto

// ChatParam 根据自身业务定义的入参
type ChatParam struct {
	Content string   `json:"content"`
	FileIds []string `json:"fileIds"`
}

// ChatRes 根据自身业务定义的出参
type ChatRes struct {
	FileRefer string `json:"fileRefer"`
	Sid       string `json:"sid"`
	Content   string `json:"content"`
}

type ChatParamForChatDoc struct {
	FileIds  []string      `json:"fileIds"`
	Messages []ChatMessage `json:"messages"`
}

type ChatMessage struct {
	Role    string `json:"role"`
	Content string `json:"content"`
}

type ChatDocRes struct {
	Code      int    `json:"code"`
	Content   string `json:"content"`
	Sid       string `json:"sid"`
	Status    int    `json:"status"`
	Message   string `json:"message"`
	FileRefer string `json:"file_refer"`
}
