package config_parser

import (
	"github.com/gogf/gf/v2/frame/g"
	"github.com/gogf/gf/v2/os/gctx"
	"github.com/gogf/gf/v2/util/gconv"
)

type ChatDocApiConfig struct {
	Host string
	Urls struct {
		UploadFile string
		Chat       string
	}
	TmpFileDir string
	AppId      string
	Secret     string
}

func (c ChatDocApiConfig) HttpHost() string {
	return "http://" + c.Host
}

func (c ChatDocApiConfig) WsHost() string {
	return "ws://" + c.Host
}

var (
	ChatDocApiConf ChatDocApiConfig
)

func init() {
	ctx := gctx.GetInitCtx()
	data := g.Cfg().MustData(ctx)
	err := gconv.Struct(data["chatDocApi"], &ChatDocApiConf)
	if err != nil {
		g.Log().Info(ctx, "parse config error")
		panic(err)
	}
	g.Log().Infof(ctx, "config: %v", ChatDocApiConf)
}
